<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Get data from request
$data = json_decode(file_get_contents("php://input"), true);
$shippingid = $data['shippingid'] ?? null; // Get shipping ID for update
$type = $data['shippingtype'] ?? null;
$startrange = $data['startrange'] ?? null;
$endrange = $data['endrange'] ?? null;
$flat = $data['flat'] ?? null;
$weight = $data['weight'] ?? null;
$rate = $data['rate'] ?? null;
$freeshippingamount = $data['freeshippingamount'] ?? null;

// Validate input
if (!$shippingid) {
    echo json_encode(["status" => "error", "message" => "Shipping ID is required"]);
    exit;
}

// Update query
$query = "UPDATE shippingmethod 
          SET shippingtype = '$type', 
              start_range = '$startrange', 
              end_range = '$endrange', 
              flat = '$flat', 
              weight = '$weight', 
              rate = '$rate', 
              free_shipping_amount = '$freeshippingamount' 
          WHERE shippingid = '$shippingid'";

$result = mysqli_query($conn, $query);

// Check update result
if ($result) {
    echo json_encode(["status" => "success", "message" => "Shipping method updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update shipping method"]);
}
?>
